using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml;
using System.Xml.Serialization;


public partial class xmlSerializerTestForm1 : Form
{
    private String fileName = Directory.GetCurrentDirectory() + "\\output1.xml";

    public xmlSerializerTestForm1()
    {
        InitializeComponent();
    }

    private void button1_Click(object sender, EventArgs e)
    {
        button1.Enabled = false;
        String name = textBox1.Text;
        String address = textBox2.Text;
        int id = Convert.ToInt32(textBox3.Text);
        String courseInfo = textBox4.Text;
        StudentInfo si = new StudentInfo(name, address, courseInfo, id);
        XmlSerializer xmls = new XmlSerializer(typeof(StudentInfo));
        TextWriter w = new StreamWriter(fileName);
        xmls.Serialize(w, si);
        w.Close();
        button1.Enabled = true;
    }

    private void button2_Click(object sender, EventArgs e)
    {
        StudentInfo si;
        XmlSerializer xmls = new XmlSerializer(typeof(StudentInfo));
        TextReader r = new StreamReader(fileName);
        si = (StudentInfo)xmls.Deserialize(r);
        textBox8.Text = si.Name;
        textBox7.Text = si.Address;
        textBox6.Text = "" + si.ID;
        textBox5.Text = si.CourseInfo;
        r.Close();

    }


}

[XmlRoot("studentInfo")]
public class StudentInfo
{
    [XmlAttribute("name")] public string Name;
    [XmlAttribute("address")] public string Address;
    [XmlAttribute("course")] public string CourseInfo;
    [XmlAttribute("id")] public int ID;
    
    public StudentInfo()
    { }

    public StudentInfo(String n, String a, String ci, int id)
    {
        Name = n; Address = a; CourseInfo = ci;
        ID = id;
    }
}
